module net.BurtonRadons.spyl.expressionExponent;

private import net.BurtonRadons.spyl.expression;
private import net.BurtonRadons.spyl.value;
private import net.BurtonRadons.spyl.mark;
private import net.BurtonRadons.spyl.scope;

/** An exponentiation expression; "a ** b". */
class ExponentExpression : BinaryExpression
{
    /** Assign the parameters. */
    this (Mark mark, Expression a, Expression b)
    {
        super (mark, a, b);
    }
    
    override Value evaluate (Scope scope)
    {
        return a.evaluate (scope).pow (b.evaluate (scope));
    }
    
    override char [] toString ()
    {
        return subString (a) ~ " ** " ~ subString (b);
    }
    
    override int precedence ()
    {
        return Precedence.Exponent; 
    } 
}
